/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import net.minecraft.core.Direction;

public class DirectionUtil {
    public static final Direction[] VALUES = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static Direction rotateAround(Direction dir, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (dir.m_122434_() == Direction.Axis.X) {
                    yield dir;
                }
                yield DirectionUtil.rotateX(dir);
            }
            case Direction.Axis.Y -> {
                if (dir.m_122434_() == Direction.Axis.Y) {
                    yield dir;
                }
                yield dir.m_122427_();
            }
            case Direction.Axis.Z -> dir.m_122434_() == Direction.Axis.Z ? dir : DirectionUtil.rotateZ(dir);
        };
    }

    private static Direction rotateX(Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Direction.DOWN;
            case Direction.SOUTH -> Direction.UP;
            case Direction.UP -> Direction.NORTH;
            case Direction.DOWN -> Direction.SOUTH;
            case Direction.EAST, Direction.WEST -> throw new IllegalStateException("Unable to get X-rotated facing of " + dir);
        };
    }

    private static Direction rotateZ(Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> Direction.DOWN;
            case Direction.WEST -> Direction.UP;
            case Direction.UP -> Direction.EAST;
            case Direction.DOWN -> Direction.WEST;
            case Direction.NORTH, Direction.SOUTH -> throw new IllegalStateException("Unable to get Z-rotated facing of " + dir);
        };
    }
}

